/************************************************************************** 
GAUSS code: Exercise 5.4(b), replicate results in Table 5.4
File: Table 54.prg
   
Modification of computer code written by Jean-Yves Pitarakis.
 
This program implements the SupLM test statistic.
The test is performed on a correctly specified model as well as 
on models specified using a model selection criterion. 
The program makes use of the TAR.PRC routine written by Bruce Hansen.  
  
Reference:
Pitarakis, J.-Y. (2006). Model selection uncertainty and detection of 
   threshold effects.
   Studies in Nonlinear Dynamics & Econometrics, 10(1), 1-30.
   DOI: 10.2202/1558-3708.1256.
************************************************************************* */
new;
format /m1 /ldn 6,4;
n=1000;            @ Number of MC replications @

modaic=zeros(n,1);
plaic=zeros(n,1);
ptaic=zeros(n,1);
dtaic=zeros(n,1);

modbic=zeros(n,1);
plbic=zeros(n,1);
ptbic=zeros(n,1);
dtbic=zeros(n,1);

modhic=zeros(n,1);
plhic=zeros(n,1);
pthic=zeros(n,1);
dthic=zeros(n,1);

t=200+50;          @ Sample Size @
y=zeros(t,1);
pmax=6;            @ Maximum Lag Length @

j=1;
do while j<=n;
   e=rndn(t,1);

  /* Model Exercise 5.4 DGP (i) */
  f01=0.5;f11=0.2;f21=-0.1; f02=0.3;f12=-0.2;f22=0.1;

  /*
  /* Model Exercise 5.4 DGP (ii) */
     f01=0.5;f11=-0.1;f21=0.1; f02=0.3;f12=0.1;f22=-0.1;
  */

  i=3;
  do while i<=t;
     y[i]=(f01+f11*y[i-1]+f21*y[i-2])*(y[i-2]<=0)+
     (f02+f12*y[i-1]+f22*y[i-2])*(y[i-2]>0)+e[i];  
     i=i+1;
  endo;

  z=y[51:rows(y)];

  vecotar=ictar(z,pmax);
  vecolin=lagsel(z,pmax);

  maiclin=vecolin[1,2];
  mbiclin=vecolin[2,2];
  mhiclin=vecolin[3,2];
  maictar=vecotar[1,3];
  mbictar=vecotar[2,3];
  mhictar=vecotar[3,3];

  /* AIC based Results */
  aicres=vecolin[1,.]~vecotar[1,.];
  if aicres[2] lt aicres[5];
    modaic[j]=0;
    plaic[j]=aicres[1];
  else;
    modaic[j]=1;
    ptaic[j]=aicres[3];
    dtaic[j]=aicres[4];
  endif;

  /* BIC based Results */
  bicres=vecolin[2,.]~vecotar[2,.];
  if bicres[2] lt bicres[5];
    modbic[j]=0;
    plbic[j]=bicres[1];
  else;
    modbic[j]=1;
    ptbic[j]=bicres[3];
    dtbic[j]=bicres[4];
  endif;

  /* HIC based Results */
  hicres=vecolin[3,.]~vecotar[3,.];
  if hicres[2] lt hicres[5];
    modhic[j]=0;
    plhic[j]=hicres[1];
  else;
    modhic[j]=1;
    pthic[j]=hicres[3];
    dthic[j]=hicres[4];
  endif;

  aicfin=modaic[j]~plaic[j]~ptaic[j]~dtaic[j];
  bicfin=modbic[j]~plbic[j]~ptbic[j]~dtbic[j];
  hicfin=modhic[j]~plhic[j]~pthic[j]~dthic[j];

  /* j~aicfin; */
  j=j+1;
endo;

veco=seqa(0,1,pmax+1);

"AIC BASED RESULTS";
" How often Linear (Coded 0) versus SETAR (coded 1)";
seqa(0,1,2)~counts(modaic,0|1)/n;
" Structure of Lag Lengths in Linear";
veco~counts(plaic,veco);
" Structure of Lags in Nonlinear";
setar=zeros(rows(ptaic),1);

k=1;
do while k<=rows(ptaic);
  if ptaic[k] eq 1 and dtaic[k] eq 1;
     setar[k]=11;
  elseif ptaic[k] eq 2 and dtaic[k] eq 1;
    setar[k]=21;
  elseif ptaic[k] eq 2 and dtaic[k] eq 2;
    setar[k]=22;
  elseif ptaic[k] eq 3 and dtaic[k] eq 1;
    setar[k]=31;
  elseif ptaic[k] eq 3 and dtaic[k] eq 2;
    setar[k]=32;
  elseif ptaic[k] eq 3 and dtaic[k] eq 3;
    setar[k]=33;
  elseif ptaic[k] eq 4 and dtaic[k] eq 1;
    setar[k]=41;
  elseif ptaic[k] eq 4 and dtaic[k] eq 2;
    setar[k]=42;
  elseif ptaic[k] eq 4 and dtaic[k] eq 3;
    setar[k]=43;
  elseif ptaic[k] eq 4 and dtaic[k] eq 4;
    setar[k]=44;
  elseif ptaic[k] eq 5 and dtaic[k] eq 1;
    setar[k]=51;
  elseif ptaic[k] eq 5 and dtaic[k] eq 2;
    setar[k]=52;
  elseif ptaic[k] eq 5 and dtaic[k] eq 3;
    setar[k]=53;
  elseif ptaic[k] eq 5 and dtaic[k] eq 4;
    setar[k]=54;
  elseif ptaic[k] eq 5 and dtaic[k] eq 5;
    setar[k]=55;
  elseif ptaic[k] eq 6 and dtaic[k] eq 1;
    setar[k]=61;
  elseif ptaic[k] eq 6 and dtaic[k] eq 2;
    setar[k]=62;
  elseif ptaic[k] eq 6 and dtaic[k] eq 3;
    setar[k]=63;
  elseif ptaic[k] eq 6 and dtaic[k] eq 4;
    setar[k]=64;
  elseif ptaic[k] eq 6 and dtaic[k] eq 5;
    setar[k]=65;
  elseif ptaic[k] eq 6 and dtaic[k] eq 6;
    setar[k]=66;
  else;
  endif;
  k=k+1;
endo;

vecs=11|21|22|31|32|33|41|42|43|44|51|52|53|54|55|61|62|63|64|65|66;
vecs~counts(setar,vecs)/rows(setar);

"BIC BASED RESULTS";
" How often Linear (Coded 0) versus SETAR (coded 1)";
seqa(0,1,2)~counts(modbic,0|1)/n;
" Structure of Lag Lengths in Linear";
veco~counts(plbic,veco);
" Structure of Lags in Nonlinear";
setarb=zeros(rows(ptbic),1);
k=1;
do while k<=rows(ptbic);
  if ptbic[k] eq 1 and dtbic[k] eq 1;
    setarb[k]=11;
  elseif ptbic[k] eq 2 and dtbic[k] eq 1;
    setarb[k]=21;
  elseif ptbic[k] eq 2 and dtbic[k] eq 2;
    setarb[k]=22;
  elseif ptbic[k] eq 3 and dtbic[k] eq 1;
    setarb[k]=31;
  elseif ptbic[k] eq 3 and dtbic[k] eq 2;
    setarb[k]=32;
  elseif ptbic[k] eq 3 and dtbic[k] eq 3;
    setarb[k]=33;
  elseif ptbic[k] eq 4 and dtbic[k] eq 1;
    setarb[k]=41;
  elseif ptbic[k] eq 4 and dtbic[k] eq 2;
    setarb[k]=42;
  elseif ptbic[k] eq 4 and dtbic[k] eq 3;
    setarb[k]=43;
  elseif ptbic[k] eq 4 and dtbic[k] eq 4;
    setarb[k]=44;
  elseif ptbic[k] eq 5 and dtbic[k] eq 1;
    setarb[k]=51;
  elseif ptbic[k] eq 5 and dtbic[k] eq 2;
    setarb[k]=52;
  elseif ptbic[k] eq 5 and dtbic[k] eq 3;
    setarb[k]=53;
  elseif ptbic[k] eq 5 and dtbic[k] eq 4;
    setarb[k]=54;
  elseif ptbic[k] eq 5 and dtbic[k] eq 5;
    setarb[k]=55;
  elseif ptbic[k] eq 6 and dtbic[k] eq 1;
    setarb[k]=61;
  elseif ptbic[k] eq 6 and dtbic[k] eq 2;
    setarb[k]=62;
  elseif ptbic[k] eq 6 and dtbic[k] eq 3;
    setarb[k]=63;
  elseif ptbic[k] eq 6 and dtbic[k] eq 4;
    setarb[k]=64;
  elseif ptbic[k] eq 6 and dtbic[k] eq 5;
    setarb[k]=65;
  elseif ptbic[k] eq 6 and dtbic[k] eq 6;
    setarb[k]=66;
  else;
  endif;
  k=k+1;
endo;

vecs=11|21|22|31|32|33|41|42|43|44|51|52|53|54|55|61|62|63|64|65|66;
vecs~counts(setarb,vecs)/rows(setarb);

"HIC BASED RESULTS";
" How often Linear (Coded 0) versus SETAR (coded 1)";
seqa(0,1,2)~counts(modhic,0|1)/n;
" Structure of Lag Lengths in Linear";
veco~counts(plhic,veco);
" Structure of Lags in Nonlinear";
setarh=zeros(rows(pthic),1);
k=1;
do while k<=rows(pthic);
  if pthic[k] eq 1 and dthic[k] eq 1;
    setarh[k]=11;
  elseif pthic[k] eq 2 and dthic[k] eq 1;
    setarh[k]=21;
  elseif pthic[k] eq 2 and dthic[k] eq 2;
    setarh[k]=22;
  elseif pthic[k] eq 3 and dthic[k] eq 1;
    setarh[k]=31;
  elseif pthic[k] eq 3 and dthic[k] eq 2;
    setarh[k]=32;
  elseif pthic[k] eq 3 and dthic[k] eq 3;
    setarh[k]=33;
  elseif pthic[k] eq 4 and dthic[k] eq 1;
    setarh[k]=41;
  elseif pthic[k] eq 4 and dthic[k] eq 2;
    setarh[k]=42;
  elseif pthic[k] eq 4 and dthic[k] eq 3;
    setarh[k]=43;
  elseif pthic[k] eq 4 and dthic[k] eq 4;
    setarh[k]=44;
  elseif pthic[k] eq 5 and dthic[k] eq 1;
    setarh[k]=51;
  elseif pthic[k] eq 5 and dthic[k] eq 2;
    setarh[k]=52;
  elseif pthic[k] eq 5 and dthic[k] eq 3;
    setarh[k]=53;
  elseif pthic[k] eq 5 and dthic[k] eq 4;
    setarh[k]=54;
  elseif pthic[k] eq 5 and dthic[k] eq 5;
    setarh[k]=55;
  elseif pthic[k] eq 6 and dthic[k] eq 1;
    setarh[k]=61;
  elseif pthic[k] eq 6 and dthic[k] eq 2;
    setarh[k]=62;
  elseif pthic[k] eq 6 and dthic[k] eq 3;
    setarh[k]=63;
  elseif pthic[k] eq 6 and dthic[k] eq 4;
    setarh[k]=64;
  elseif pthic[k] eq 6 and dthic[k] eq 5;
    setarh[k]=65;
  elseif pthic[k] eq 6 and dthic[k] eq 6;
    setarh[k]=66;
  else;
  endif;
  k=k+1;
endo;

vecs=11|21|22|31|32|33|41|42|43|44|51|52|53|54|55|61|62|63|64|65|66;
vecs~counts(setarh,vecs)/rows(setarh);

/* output off; */

/* PROCEDURES */
proc (1) = ictar(dat,pmax);

local d, np, store, n, ic, p, y, t, x, j, q, qq, qn, gn, ssq,
bic, trim1, hic, qm, sam, r, gg, xmat, vecaic, vecbic, vechic,
aic,reso1;

np=pmax*(pmax+1)/2;
store=zeros(pmax,np*5);
n=rows(dat);

p=1;
ic=1;

do while p<=pmax;
  y=dat[p+1:n];
  t=n-p;
  x=ones(t,1);
  j=1; do while j<=p;
    x=x~dat[p+1-j:n-j];
  j=j+1;
  endo;

x=x[.,1:p+1];

d=1;
do while d<=p;
  q=x[.,2:d+1];  /* Threshold Variable(s) */
  qq=qsort(q);
  qn=cols(q);
  gn=rows(qq);

ssq=zeros(gn,1);
bic=zeros(gn,1);
aic=zeros(gn,1);
hic=zeros(gn,1);
qm=q[.,d];
sam=rows(y);


r=1;
do while r<=gn;
gg=qq[r,d];
if scalmiss(gg);continue;endif;
xmat=x.*(qm.<=gg)~x.*(qm.>gg);
ssq[r]=(y'y-y'xmat*invpd(xmat'xmat)*xmat'y)/sam;
bic[r]=ln(ssq[r])+(ln(sam)/sam)*(2*(p+1));
aic[r]=ln(ssq[r])+(2/sam)*(2*(p+1));
hic[r]=ln(ssq[r])+(2*ln(ln(sam))/sam)*(2*(p+1));
r=r+1;
endo;

store[p,ic:ic+4]=p~d~minc(aic)~minc(bic)~minc(hic);
ic=ic+5;

d=d+1;
endo;

p=p+1;
endo;

reso1=packr(miss(reshape(store,pmax*np,5),0));
vecaic=reso1[minindc(reso1[.,3]),1:3];
vecbic=reso1[minindc(reso1[.,4]),1:2 4];
vechic=reso1[minindc(reso1[.,5]),1:2 5];

retp(vecaic|vecbic|vechic);


endp;


proc qsort(q);
local j,n,n1,qq,k,qj,nj;
  n=rows(q);k=cols(q);
  n1=round(0.1*n);
qq=zeros(n-n1-n1+2,k);
    qq=miss(qq,0);
    j=1; do while j<=k;
      qj=unique(q[.,j],1);
      qj=qj[n1:(rows(qj)-n1+1)];
      qq[1:rows(qj),j]=qj;
    j=j+1;endo;
retp(qq);
endp;

/* LINEAR FITS */

/* LAGSEL PROCEDURE */

proc (1) = lagsel(dat,maxlag);
local laic,lbic,lhic,k,y,h,yr,z,beta,res,rres,plinaic,plinbic,plinhic,n,sig;

laic=zeros(maxlag,1);
lbic=zeros(maxlag,1);
lhic=zeros(maxlag,1);
sig=zeros(maxlag,1);

n=rows(dat);

k=1;
do while k<=maxlag;
y=dat[k+1:n];
h=1;
do while h<=k;
y=y~dat[k+1-h:n-h];
h=h+1;
endo;

yr=y[.,1];

z=ones(rows(yr),1)~y[.,2:cols(y)];

beta=yr/z;
res=yr-z*beta;
rres=rows(res);

laic[k]=ln(res'res/rres)+(2/rres)*(k+1);
lbic[k]=ln(res'res/rres)+(ln(rres)/rres)*(k+1);
lhic[k]=ln(res'res/rres)+(2*ln(ln(rres))/rres)*(k+1);

k=k+1;
endo;

plinaic=minindc(laic)~minc(laic);
plinbic=minindc(lbic)~minc(lbic);
plinhic=minindc(lhic)~minc(lhic);

retp(plinaic|plinbic|plinhic);
endp;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
AIC BASED RESULTS; AR  (Table 4, OK): True Input p=2  NO d
 How often Linear (Coded 0) versus SETAR (coded 1)

 0.0000 0.0190
 1.0000 0.9810
Structure of Lag Lengths in Linear

 0.0000 981.0000
 1.0000 12.0000
 2.0000 2.0000
 3.0000 3.0000
 4.0000 2.0000
 5.0000 0.0000
 6.0000 0.0000
Structure of Lags in Nonlinear:  
(p,d)=(1,1),(2,1),(2,2),(3,1),(3,2),(3.3),....(6,6)

 11.0000 0.1480
 21.0000 0.0850
 22.0000 0.1600
 31.0000 0.0360
 32.0000 0.0420
 33.0000 0.0990
 41.0000 0.0220
 42.0000 0.0280
 43.0000 0.0280
 44.0000 0.0630
 51.0000 0.0160
 52.0000 0.0280
 53.0000 0.0120
 54.0000 0.0260
 55.0000 0.0460
 61.0000 0.0130
 62.0000 0.0230
 63.0000 0.0200
 64.0000 0.0150
 65.0000 0.0310
 66.0000 0.0590
BIC BASED RESULTS
 How often Linear (Coded 0) versus SETAR (coded 1)

 0.0000 0.9090
 1.0000 0.0910
Structure of Lag Lengths in Linear

 0.0000 91.0000
 1.0000 695.0000
 2.0000 201.0000
 3.0000 10.0000
 4.0000 3.0000
 5.0000 0.0000
 6.0000 0.0000
Structure of Lags in Nonlinear
(p,d)=(1,1),(2,1),(2,2),(3,1),(3,2),(3.3),....(6,6)

 11.0000 0.9770
 21.0000 0.0080
 22.0000 0.0140
 31.0000 0.0000
 32.0000 0.0000
 33.0000 0.0010
 41.0000 0.0000
 42.0000 0.0000
 43.0000 0.0000
 44.0000 0.0000
 51.0000 0.0000
 52.0000 0.0000
 53.0000 0.0000
 54.0000 0.0000
 55.0000 0.0000
 61.0000 0.0000
 62.0000 0.0000
 63.0000 0.0000
 64.0000 0.0000
 65.0000 0.0000
 66.0000 0.0000
HIC BASED RESULTS
 How often Linear (Coded 0) versus SETAR (coded 1)

 0.0000 0.4830
 1.0000 0.5170
Structure of Lag Lengths in Linear

 0.0000 517.0000
 1.0000 284.0000
 2.0000 154.0000
 3.0000 17.0000
 4.0000 16.0000
 5.0000 9.0000
 6.0000 3.0000
Structure of Lags in Nonlinear
(p,d)=(1,1),(2,1),(2,2),(3,1),(3,2),(3.3),....(6,6)

 11.0000 0.6930
 21.0000 0.0570
 22.0000 0.1320
 31.0000 0.0110
 32.0000 0.0180
 33.0000 0.0380
 41.0000 0.0020
 42.0000 0.0020
 43.0000 0.0040
 44.0000 0.0160
 51.0000 0.0030
 52.0000 0.0040
 53.0000 0.0020
 54.0000 0.0020
 55.0000 0.0050
 61.0000 0.0010
 62.0000 0.0020
 63.0000 0.0030
 64.0000 0.0010
 65.0000 0.0010
 66.0000 0.0030

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
Table 5, Model E, SETAR; True p=2, d=2
AIC BASED RESULTS
 How often Linear (Coded 0) versus SETAR (coded 1)

 0.0000 0.0120
 1.0000 0.9880
Structure of Lag Lengths in Linear

 0.0000 988.0000
 1.0000 8.0000
 2.0000 2.0000
 3.0000 0.0000
 4.0000 0.0000
 5.0000 0.0000
 6.0000 2.0000
Structure of Lags in Nonlinear
(p,d)=(1,1),(2,1),(2,2),(3,1),(3,2),(3.3),....(6,6)

 11.0000 0.1660
 21.0000 0.0820
 22.0000 0.2430
 31.0000 0.0290
 32.0000 0.0670
 33.0000 0.0550
 41.0000 0.0180
 42.0000 0.0270
 43.0000 0.0210
 44.0000 0.0350
 51.0000 0.0220
 52.0000 0.0140
 53.0000 0.0220
 54.0000 0.0170
 55.0000 0.0330
 61.0000 0.0210
 62.0000 0.0140
 63.0000 0.0180
 64.0000 0.0170
 65.0000 0.0250
 66.0000 0.0540
BIC BASED RESULTS
 How often Linear (Coded 0) versus SETAR (coded 1)

 0.0000 0.8580
 1.0000 0.1420
Structure of Lag Lengths in Linear

 0.0000 142.0000
 1.0000 786.0000
 2.0000 65.0000
 3.0000 4.0000
 4.0000 3.0000
 5.0000 0.0000
 6.0000 0.0000
Structure of Lags in Nonlinear
(p,d)=(1,1),(2,1),(2,2),(3,1),(3,2),(3.3),....(6,6)

 11.0000 0.9580
 21.0000 0.0050
 22.0000 0.0360
 31.0000 0.0000
 32.0000 0.0000
 33.0000 0.0010
 41.0000 0.0000
 42.0000 0.0000
 43.0000 0.0000
 44.0000 0.0000
 51.0000 0.0000
 52.0000 0.0000
 53.0000 0.0000
 54.0000 0.0000
 55.0000 0.0000
 61.0000 0.0000
 62.0000 0.0000
 63.0000 0.0000
 64.0000 0.0000
 65.0000 0.0000
 66.0000 0.0000
HIC BASED RESULTS
 How often Linear (Coded 0) versus SETAR (coded 1)

 0.0000 0.3690
 1.0000 0.6310
Structure of Lag Lengths in Linear

 0.0000 631.0000
 1.0000 299.0000
 2.0000 37.0000
 3.0000 14.0000
 4.0000 9.0000
 5.0000 5.0000
 6.0000 5.0000
Structure of Lags in Nonlinear
(p,d)=(1,1),(2,1),(2,2),(3,1),(3,2),(3.3),....(6,6)

 11.0000 0.6490
 21.0000 0.0600
 22.0000 0.2100
 31.0000 0.0080
 32.0000 0.0200
 33.0000 0.0150
 41.0000 0.0030
 42.0000 0.0020
 43.0000 0.0030
 44.0000 0.0080
 51.0000 0.0010
 52.0000 0.0010
 53.0000 0.0030
 54.0000 0.0050
 55.0000 0.0020
 61.0000 0.0010
 62.0000 0.0010
 63.0000 0.0000
 64.0000 0.0010
 65.0000 0.0030
 66.0000 0.0040

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
/* Model Exercise 5.4 DGP (i) */, n=200
f01=0.5;f11=0.2;f21=-0.1; f02=0.3;f12=-0.2;f22=0.1;

AIC BASED RESULTS
 How often Linear (Coded 0) versus SETAR (coded 1)

 0.0000 0.0020
 1.0000 0.9980
 Structure of Lag Lengths in Linear

 0.0000 998.0000
 1.0000 2.0000
 2.0000 0.0000
 3.0000 0.0000
 4.0000 0.0000
 5.0000 0.0000
 6.0000 0.0000
 Structure of Lags in Nonlinear

 11.0000 0.0320
 21.0000 0.0670
 22.0000 0.4940
 31.0000 0.0200
 32.0000 0.1140
 33.0000 0.0240
 41.0000 0.0200
 42.0000 0.0450
 43.0000 0.0110
 44.0000 0.0200
 51.0000 0.0130
 52.0000 0.0300
 53.0000 0.0080
 54.0000 0.0110
 55.0000 0.0150
 61.0000 0.0110
 62.0000 0.0280
 63.0000 0.0090
 64.0000 0.0070
 65.0000 0.0090
 66.0000 0.0120
BIC BASED RESULTS
 How often Linear (Coded 0) versus SETAR (coded 1)

 0.0000 0.5200
 1.0000 0.4800
 Structure of Lag Lengths in Linear

 0.0000 480.0000
 1.0000 411.0000
 2.0000 92.0000
 3.0000 11.0000
 4.0000 5.0000
 5.0000 1.0000
 6.0000 0.0000
 Structure of Lags in Nonlinear

 11.0000 0.5770
 21.0000 0.0320
 22.0000 0.3870
 31.0000 0.0000
 32.0000 0.0030
 33.0000 0.0000
 41.0000 0.0000
 42.0000 0.0000
 43.0000 0.0010
 44.0000 0.0000
 51.0000 0.0000
 52.0000 0.0000
 53.0000 0.0000
 54.0000 0.0000
 55.0000 0.0000
 61.0000 0.0000
 62.0000 0.0000
 63.0000 0.0000
 64.0000 0.0000
 65.0000 0.0000
 66.0000 0.0000
HIC BASED RESULTS
 How often Linear (Coded 0) versus SETAR (coded 1)

 0.0000 0.1010
 1.0000 0.8990
 Structure of Lag Lengths in Linear

 0.0000 899.0000
 1.0000 58.0000
 2.0000 30.0000
 3.0000 6.0000
 4.0000 5.0000
 5.0000 1.0000
 6.0000 1.0000
 Structure of Lags in Nonlinear

 11.0000 0.1930
 21.0000 0.0770
 22.0000 0.6240
 31.0000 0.0080
 32.0000 0.0480
 33.0000 0.0130
 41.0000 0.0100
 42.0000 0.0100
 43.0000 0.0040
 44.0000 0.0040
 51.0000 0.0010
 52.0000 0.0020
 53.0000 0.0010
 54.0000 0.0000
 55.0000 0.0010
 61.0000 0.0000
 62.0000 0.0020
 63.0000 0.0000
 64.0000 0.0000
 65.0000 0.0000
 66.0000 0.0020

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
/* Model Exercise 5.4 DGP (i) */, n = 500
f01=0.5;f11=0.2;f21=-0.1; f02=0.3;f12=-0.2;f22=0.1;
AIC BASED RESULTS
 How often Linear (Coded 0) versus SETAR (coded 1)

 0.0000 0.0000
 1.0000 1.0000
 Structure of Lag Lengths in Linear

 0.0000 1000.0000
 1.0000 0.0000
 2.0000 0.0000
 3.0000 0.0000
 4.0000 0.0000
 5.0000 0.0000
 6.0000 0.0000
 Structure of Lags in Nonlinear

 11.0000 0.0010
 21.0000 0.0220
 22.0000 0.6730
 31.0000 0.0030
 32.0000 0.1320
 33.0000 0.0030
 41.0000 0.0070
 42.0000 0.0780
 43.0000 0.0000
 44.0000 0.0040
 51.0000 0.0010
 52.0000 0.0510
 53.0000 0.0010
 54.0000 0.0010
 55.0000 0.0000
 61.0000 0.0010
 62.0000 0.0200
 63.0000 0.0000
 64.0000 0.0000
 65.0000 0.0000
 66.0000 0.0020
BIC BASED RESULTS
 How often Linear (Coded 0) versus SETAR (coded 1)

 0.0000 0.0880
 1.0000 0.9120
 Structure of Lag Lengths in Linear

 0.0000 912.0000
 1.0000 57.0000
 2.0000 29.0000
 3.0000 2.0000
 4.0000 0.0000
 5.0000 0.0000
 6.0000 0.0000
 Structure of Lags in Nonlinear

 11.0000 0.0940
 21.0000 0.0190
 22.0000 0.8800
 31.0000 0.0000
 32.0000 0.0070
 33.0000 0.0000
 41.0000 0.0000
 42.0000 0.0000
 43.0000 0.0000
 44.0000 0.0000
 51.0000 0.0000
 52.0000 0.0000
 53.0000 0.0000
 54.0000 0.0000
 55.0000 0.0000
 61.0000 0.0000
 62.0000 0.0000
 63.0000 0.0000
 64.0000 0.0000
 65.0000 0.0000
 66.0000 0.0000
HIC BASED RESULTS
 How often Linear (Coded 0) versus SETAR (coded 1)

 0.0000 0.0090
 1.0000 0.9910
 Structure of Lag Lengths in Linear

 0.0000 991.0000
 1.0000 5.0000
 2.0000 3.0000
 3.0000 1.0000
 4.0000 0.0000
 5.0000 0.0000
 6.0000 0.0000
 Structure of Lags in Nonlinear

 11.0000 0.0100
 21.0000 0.0260
 22.0000 0.9000
 31.0000 0.0010
 32.0000 0.0480
 33.0000 0.0000
 41.0000 0.0000
 42.0000 0.0090
 43.0000 0.0000
 44.0000 0.0020
 51.0000 0.0000
 52.0000 0.0040
 53.0000 0.0000
 54.0000 0.0000
 55.0000 0.0000
 61.0000 0.0000
 62.0000 0.0000
 63.0000 0.0000
 64.0000 0.0000
 65.0000 0.0000
 66.0000 0.0000

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
/* Model Exercise 5.4 DGP (ii) */  n = 200
f01=0.5;f11=-0.1;f21=0.1;f02=0.3;f12=0.1;f22=-0.1;

AIC BASED RESULTS
 How often Linear (Coded 0) versus SETAR (coded 1)

 0.0000 0.0110
 1.0000 0.9890
 Structure of Lag Lengths in Linear

 0.0000 989.0000
 1.0000 9.0000
 2.0000 0.0000
 3.0000 1.0000
 4.0000 0.0000
 5.0000 0.0000
 6.0000 1.0000
 Structure of Lags in Nonlinear

 11.0000 0.1330
 21.0000 0.1010
 22.0000 0.1980
 31.0000 0.0470
 32.0000 0.0590
 33.0000 0.0660
 41.0000 0.0300
 42.0000 0.0270
 43.0000 0.0260
 44.0000 0.0460
 51.0000 0.0220
 52.0000 0.0170
 53.0000 0.0180
 54.0000 0.0220
 55.0000 0.0340
 61.0000 0.0230
 62.0000 0.0210
 63.0000 0.0210
 64.0000 0.0160
 65.0000 0.0220
 66.0000 0.0510
BIC BASED RESULTS
 How often Linear (Coded 0) versus SETAR (coded 1)

 0.0000 0.8610
 1.0000 0.1390
 Structure of Lag Lengths in Linear

 0.0000 139.0000
 1.0000 702.0000
 2.0000 144.0000
 3.0000 10.0000
 4.0000 5.0000
 5.0000 0.0000
 6.0000 0.0000
 Structure of Lags in Nonlinear

 11.0000 0.9420
 21.0000 0.0080
 22.0000 0.0490
 31.0000 0.0000
 32.0000 0.0000
 33.0000 0.0000
 41.0000 0.0000
 42.0000 0.0000
 43.0000 0.0000
 44.0000 0.0010
 51.0000 0.0000
 52.0000 0.0000
 53.0000 0.0000
 54.0000 0.0000
 55.0000 0.0000
 61.0000 0.0000
 62.0000 0.0000
 63.0000 0.0000
 64.0000 0.0000
 65.0000 0.0000
 66.0000 0.0000
HIC BASED RESULTS
 How often Linear (Coded 0) versus SETAR (coded 1)

 0.0000 0.3600
 1.0000 0.6400
 Structure of Lag Lengths in Linear

 0.0000 640.0000
 1.0000 241.0000
 2.0000 77.0000
 3.0000 24.0000
 4.0000 11.0000
 5.0000 3.0000
 6.0000 4.0000
 Structure of Lags in Nonlinear

 11.0000 0.5980
 21.0000 0.0830
 22.0000 0.2130
 31.0000 0.0140
 32.0000 0.0250
 33.0000 0.0270
 41.0000 0.0050
 42.0000 0.0080
 43.0000 0.0000
 44.0000 0.0130
 51.0000 0.0000
 52.0000 0.0020
 53.0000 0.0010
 54.0000 0.0010
 55.0000 0.0030
 61.0000 0.0010
 62.0000 0.0010
 63.0000 0.0010
 64.0000 0.0000
 65.0000 0.0020
 66.0000 0.0020
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 
/* Model Exercise 5.4 DGP (ii) */  n = 500
f01=0.5;f11=-0.1;f21=0.1;f02=0.3;f12=0.1;f22=-0.1;

AIC BASED RESULTS
 How often Linear (Coded 0) versus SETAR (coded 1)

 0.0000 0.0060
 1.0000 0.9940
 Structure of Lag Lengths in Linear

 0.0000 994.0000
 1.0000 3.0000
 2.0000 1.0000
 3.0000 0.0000
 4.0000 1.0000
 5.0000 1.0000
 6.0000 0.0000
 Structure of Lags in Nonlinear

 11.0000 0.0510
 21.0000 0.1200
 22.0000 0.3560
 31.0000 0.0330
 32.0000 0.0820
 33.0000 0.0470
 41.0000 0.0260
 42.0000 0.0370
 43.0000 0.0230
 44.0000 0.0290
 51.0000 0.0150
 52.0000 0.0290
 53.0000 0.0100
 54.0000 0.0170
 55.0000 0.0280
 61.0000 0.0130
 62.0000 0.0200
 63.0000 0.0100
 64.0000 0.0080
 65.0000 0.0160
 66.0000 0.0300
BIC BASED RESULTS
 How often Linear (Coded 0) versus SETAR (coded 1)

 0.0000 0.8360
 1.0000 0.1640
 Structure of Lag Lengths in Linear

 0.0000 164.0000
 1.0000 624.0000
 2.0000 204.0000
 3.0000 6.0000
 4.0000 2.0000
 5.0000 0.0000
 6.0000 0.0000
 Structure of Lags in Nonlinear

 11.0000 0.8740
 21.0000 0.0170
 22.0000 0.1070
 31.0000 0.0000
 32.0000 0.0020
 33.0000 0.0000
 41.0000 0.0000
 42.0000 0.0000
 43.0000 0.0000
 44.0000 0.0000
 51.0000 0.0000
 52.0000 0.0000
 53.0000 0.0000
 54.0000 0.0000
 55.0000 0.0000
 61.0000 0.0000
 62.0000 0.0000
 63.0000 0.0000
 64.0000 0.0000
 65.0000 0.0000
 66.0000 0.0000
HIC BASED RESULTS
 How often Linear (Coded 0) versus SETAR (coded 1)

 0.0000 0.2780
 1.0000 0.7220
 Structure of Lag Lengths in Linear

 0.0000 722.0000
 1.0000 146.0000
 2.0000 105.0000
 3.0000 15.0000
 4.0000 8.0000
 5.0000 3.0000
 6.0000 1.0000
 Structure of Lags in Nonlinear

 11.0000 0.4050
 21.0000 0.1140
 22.0000 0.4010
 31.0000 0.0100
 32.0000 0.0320
 33.0000 0.0160
 41.0000 0.0010
 42.0000 0.0040
 43.0000 0.0000
 44.0000 0.0080
 51.0000 0.0010
 52.0000 0.0020
 53.0000 0.0000
 54.0000 0.0010
 55.0000 0.0010
 61.0000 0.0010
 62.0000 0.0000
 63.0000 0.0000
 64.0000 0.0000
 65.0000 0.0010
 66.0000 0.0020









 













